package com.mpaa.decss;


/**
 * Title:        MirrorBitsTable.java
 * Description:  This table is a single byte binary mirror-image lookup.  For example 0000 0001 (0x01) mirror-imaged is 1000 0000 (0x80).
 *               In other words, this table will reverse the order of the bits within a byte
 * @author DiatriBe
 * @version 1.0
 */

public class MirrorBitsTable
{
	private static MirrorBitsTable onlyInstance = null;

	private static boolean initialized = false;

	private int values[] = null;


	protected MirrorBitsTable()       // Shouldn't actually try to create one of these
	{
		initialize();
	}

	public synchronized static MirrorBitsTable getInstance()
	{
		if (onlyInstance == null)
			onlyInstance = new MirrorBitsTable();

		return onlyInstance;
	}

	public int getAt(int index)
	{
		return values[index];
	}

	private void initialize()
	{
		values = new int[256];

		for (int index1 = 0; index1 < 256; index1++)
		{
			int value = 0;
			for (int index2 = 0; index2 < 8; index2++)
			{
				value |= ((index1 >> index2) & 0x01) << (7 - index2);
			}
			values[index1] = value & 0xFF;
		}
		initialized = true;
	}

	public String toString()
	{
		String tableString = new String();

		for (int index = 0; index < 256; index++)
		{
			if ((index % 16) == 0)
				tableString += "\n";

			String hexString = (Integer.toHexString(values[index])).toUpperCase();

			if (hexString.length() == 1)
				hexString = "0x0" + hexString;
			else
				hexString = "0x" + hexString;

			tableString += hexString + ", ";
		}
		return tableString;
	}

	public static void main(String[] args)
	{
		(MirrorBitsTable.getInstance()).toString();
	}
}

