/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;

final class ReadTrack {
    protected String chunkType;
    protected byte[] data;
    private int inPos;
    private byte lastStatus;

    public ReadTrack(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        this.chunkType = new String(byArray);
        inputStream.read(byArray);
        int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        System.err.println(this.chunkType + " " + n + " (" + byArray[0] + "," + byArray[1] + "," + byArray[2] + "," + byArray[3] + ")");
        this.data = new byte[n];
        inputStream.read(this.data);
        this.inPos = 0;
    }

    public ReadTrack(String string, byte[] byArray) {
        this.data = (byte[])byArray.clone();
        this.chunkType = string;
        this.inPos = 0;
    }

    public String toString() {
        return "ReadTrack " + this.chunkType + ", " + this.data.length + " bytes";
    }

    public byte readByte() {
        return this.data[this.inPos++];
    }

    public void read(byte[] byArray, int n, int n2) {
        System.arraycopy(this.data, this.inPos, byArray, n, n2);
        this.inPos += n2;
    }

    public void read(byte[] byArray) {
        this.read(byArray, 0, byArray.length);
    }

    public int readVarLen() {
        int n = this.readByte();
        if ((n & 0x80) != 0) {
            byte by;
            n &= 0x7F;
            do {
                by = this.readByte();
                n = (n << 7) + (by & 0x7F);
            } while ((by & 0xFFFFFF80) != 0);
        }
        return n;
    }

    public void unReadByte() {
        --this.inPos;
    }

    public Event readEvent() {
        if (this.inPos >= this.data.length) {
            return null;
        }
        int n = this.readVarLen();
        byte by = this.readByte();
        if ((by & 0xFFFFFF80) == 0) {
            System.out.println(by + " " + (by & 0xFFFFFF80) + " " + this.lastStatus);
            System.out.println((by & 0xFFFFFF80) == 0);
            this.unReadByte();
            by = this.lastStatus;
        } else {
            this.lastStatus = by;
        }
        byte[] byArray = null;
        if (by == -1) {
            byte by2 = this.readByte();
            int n2 = this.readVarLen();
            byArray = new byte[1 + n2];
            byArray[0] = by2;
            this.read(byArray, 1, n2);
        } else {
            int n3;
            block0 : switch (by & 0xFFFFFFF0) {
                case -128: 
                case -112: 
                case -96: 
                case -80: 
                case -32: {
                    n3 = 2;
                    break;
                }
                case -64: 
                case -48: {
                    n3 = 1;
                    break;
                }
                case -16: {
                    switch (by & 0xF) {
                        case 0: 
                        case 7: {
                            n3 = this.readVarLen();
                            break block0;
                        }
                        case 1: 
                        case 3: {
                            n3 = 1;
                            break block0;
                        }
                        case 2: {
                            n3 = 2;
                            break block0;
                        }
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 14: {
                            n3 = 0;
                            break block0;
                        }
                    }
                    throw new RuntimeException("Invalid MIDI byte or broken parser?");
                }
                default: {
                    throw new RuntimeException("I'm confused");
                }
            }
            byArray = new byte[n3];
            this.read(byArray);
        }
        return new Event(n, by, byArray);
    }

    public static class Event {
        public int deltaTime;
        public byte status;
        public byte[] data;

        public Event(int n, byte by, byte[] byArray) {
            this.deltaTime = n;
            this.status = by;
            this.data = byArray;
        }
    }
}

