/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MidiC {
    protected InputStream in;
    protected OutputStream out;
    protected int ppqn;

    public MidiC(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
    }

    public void doConversion() throws IOException {
        ReadTrack.Event event;
        ReadTrack readTrack;
        this.readHeader();
        do {
            readTrack = new ReadTrack(this.in);
        } while (!readTrack.chunkType.equals("MTrk"));
        while ((event = readTrack.readEvent()) != null) {
            if (event.status != -128 && (event.status != -112 || event.data[1] != 0)) continue;
            if (event.deltaTime >= this.ppqn / 2) {
                this.out.write(10);
            } else if (event.deltaTime >= this.ppqn / 4) {
                this.out.write(32);
            }
            this.out.write(event.data[0]);
        }
    }

    private void readHeader() throws IOException {
        ReadTrack readTrack;
        ReadTrack readTrack2 = new ReadTrack(this.in);
        if (!readTrack2.chunkType.equals("MThd") || readTrack2.data.length != 6) {
            throw new RuntimeException("input is not a MIDI file");
        }
        if (readTrack2.data[1] != 1) {
            throw new RuntimeException("I can only handle format-1 MIDI files");
        }
        if (readTrack2.data[4] < 0) {
            throw new RuntimeException("I don't yet know how to handle SMTPE-timecoded MIDI files");
        }
        this.ppqn = readTrack2.data[4] << 8 | readTrack2.data[5];
        do {
            readTrack = new ReadTrack(this.in);
        } while (!readTrack.chunkType.equals("MTrk"));
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 2) {
            System.out.println("Syntax:");
            System.out.println("\tjava MidiC infile.mid outfile.c");
            System.out.println("\t\"-\" means use stdin/out");
            System.exit(1);
        }
        InputStream inputStream = stringArray[0].equals("-") ? System.in : new FileInputStream(stringArray[0]);
        OutputStream outputStream = stringArray[1].equals("-") ? System.out : new FileOutputStream(stringArray[1]);
        MidiC midiC = new MidiC(inputStream, outputStream);
        midiC.doConversion();
        inputStream.close();
        outputStream.close();
    }
}

