/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMidi {
    protected InputStream in;
    protected OutputStream out;

    public CMidi(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
    }

    public void doConversion() throws IOException {
        int n;
        this.writeHeader();
        TrackChunk trackChunk = new TrackChunk();
        trackChunk.addBytes(new byte[]{0, -80, 121, 0});
        trackChunk.addBytes(new byte[]{0, 0, 0});
        trackChunk.addBytes(new byte[]{0, -64, 25});
        trackChunk.addBytes(new byte[]{0, -80, 7, 127});
        while ((n = this.in.read()) != -1) {
            trackChunk.writeDataByte((byte)n);
        }
        trackChunk.endTrack();
        this.writeChunk("MTrk", trackChunk.getBytes());
    }

    protected void writeHeader() throws IOException {
        byte[] byArray = new byte[]{0, 1, 0, 2, 0, 96};
        this.writeChunk("MThd", byArray);
        TrackChunk trackChunk = new TrackChunk();
        trackChunk.addVarLen(0);
        trackChunk.addByte((byte)-1);
        trackChunk.addByte((byte)81);
        trackChunk.addByte((byte)3);
        trackChunk.addByte((byte)7);
        trackChunk.addByte((byte)-95);
        trackChunk.addByte((byte)32);
        trackChunk.addVarLen(0);
        trackChunk.addText("This file was created by CMidi. Run MidiC to get the data back out.");
        trackChunk.endTrack();
        this.writeChunk("MTrk", trackChunk.getBytes());
    }

    protected void writeChunk(String string, byte[] byArray) throws IllegalArgumentException, IOException {
        if (string.length() != 4) {
            throw new IllegalArgumentException("Bad type");
        }
        this.out.write(string.getBytes());
        int n = byArray.length;
        this.out.write((byte)((n & 0xFF00000) >> 24));
        this.out.write((byte)((n & 0xFF000) >> 16));
        this.out.write((byte)((n & 0xFF00) >> 8));
        this.out.write((byte)(n & 0xFF));
        this.out.write(byArray);
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 2) {
            System.out.println("Syntax:");
            System.out.println("    java CMidi infile.c outfile.mid");
            System.exit(1);
        }
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
        CMidi cMidi = new CMidi(fileInputStream, fileOutputStream);
        cMidi.doConversion();
        fileInputStream.close();
        fileOutputStream.close();
    }
}

